/*
 * Decompiled with CFR 0.152.
 */
package com.dfdyz.epicacg.event;

import com.dfdyz.epicacg.config.ClientConfig;
import com.dfdyz.epicacg.registry.Particles;
import com.dfdyz.epicacg.utils.DeathParticleHandler;
import com.dfdyz.epicacg.utils.GlobalVal;
import com.google.common.collect.Lists;
import java.util.LinkedList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLEnvironment;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;

@Mod.EventBusSubscriber(modid="epicacg")
public class EpicACGWorldEvent {
    public static final LinkedList<LivingEntity> DeathEntities = Lists.newLinkedList();

    @SubscribeEvent
    public static void OnEntityDeath(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        Level level = entity.m_9236_();
        if (!level.m_5776_()) {
            return;
        }
        DeathEntities.add(entity);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent event) {
        if (FMLEnvironment.dist != Dist.CLIENT) {
            return;
        }
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        GlobalVal.WX = (float)Math.cos(GlobalVal.WANG += 0.035f);
        GlobalVal.WZ = -((float)Math.sin(GlobalVal.WANG));
        DeathEntities.forEach(entity -> {
            if (entity.f_20919_ >= 18 && ClientConfig.cfg.EnableDeathParticle) {
                EpicACGWorldEvent.ShootDeathParticle(entity);
            }
        });
        DeathEntities.removeIf(entity -> entity.f_20919_ >= 18);
    }

    private static void ShootDeathParticle(LivingEntity entity) {
        Level level = entity.m_9236_();
        String regName = EntityType.m_20613_((EntityType)entity.m_6095_()).toString();
        DeathParticleHandler.ParticleTransform transformType = DeathParticleHandler.config.custom.get(regName);
        if (transformType == null) {
            LazyOptional capability = entity.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY);
            Vec3 pos = entity.m_20182_();
            AABB box = entity.m_20191_();
            float rot = entity.f_20883_;
            Vec3 minVec = new Vec3(box.f_82288_, box.f_82289_ - (double)0.85f, box.f_82290_).m_82546_(pos);
            Vec3 maxVec = new Vec3(box.f_82291_, box.f_82292_ - (double)0.85f, box.f_82293_).m_82546_(pos);
            int eid = entity.m_19879_();
            double patchedEid = Double.longBitsToDouble(eid);
            Vec3 rotation = capability.isPresent() ? new Vec3(90.0, (double)(-rot), 0.0) : new Vec3(90.0, (double)(-90.0f - rot), 0.0);
            DeathParticleHandler.TransformPool.putIfAbsent(eid, new DeathParticleHandler.ParticleTransformed(Vec3.f_82478_, minVec, maxVec, rotation, DeathParticleHandler.config.default_density));
            level.m_7106_((ParticleOptions)Particles.SAO_DEATH.get(), pos.f_82479_, pos.f_82480_, pos.f_82481_, patchedEid, 0.0, 0.0);
        } else {
            Vec3 maxVec;
            Vec3 minVec;
            Vec3 pos = entity.m_20182_();
            if (transformType.type <= 1) {
                AABB box = entity.m_20191_();
                minVec = new Vec3(box.f_82288_, box.f_82289_, box.f_82290_).m_82546_(pos);
                maxVec = new Vec3(box.f_82291_, box.f_82292_, box.f_82293_).m_82546_(pos);
            } else {
                minVec = transformType.minV;
                maxVec = transformType.maxV;
            }
            float rx = 0.0f;
            float ry = 0.0f;
            float rz = 0.0f;
            if (transformType.type == 1 || transformType.type == 2 || transformType.type == 4) {
                ry -= entity.f_20883_;
            }
            if (transformType.type >= 3) {
                rx += (float)transformType.rot.f_82479_;
                ry += (float)transformType.rot.f_82480_;
                rz += (float)transformType.rot.f_82481_;
            }
            Vec3 rotation = new Vec3((double)rx, (double)ry, (double)rz);
            int eid = entity.m_19879_();
            double patchedEid = Double.longBitsToDouble(eid);
            if (transformType.type >= 2) {
                DeathParticleHandler.TransformPool.putIfAbsent(eid, new DeathParticleHandler.ParticleTransformed(transformType.offset, minVec, maxVec, rotation, transformType.density));
            } else {
                DeathParticleHandler.TransformPool.putIfAbsent(eid, new DeathParticleHandler.ParticleTransformed(Vec3.f_82478_, minVec, maxVec, rotation, transformType.density));
            }
            level.m_7106_((ParticleOptions)Particles.SAO_DEATH.get(), pos.f_82479_, pos.f_82480_, pos.f_82481_, patchedEid, 0.0, 0.0);
        }
    }
}

